#include <amxmodx>
#include <amxmisc>
#include <engine>
#include <fakemeta>
#include <hamsandwich>
#include <fun>
#include <cstrike>
#include <dhudmessage>

#define PLUGIN_NAME	"[JB]CT Classes"
#define PLUGIN_AUTHOR	"Real-Servers.ru"
#define PLUGIN_VERSION	"1.0"
#define PLUGIN_CVAR	"jb_classes"

#define ADMIN_CLASS ADMIN_BAN

new g_userclass[33];
new bool:g_classselected[33];
new bool:g_nomsg[33];

new gp_Informer, gc_Informer;

public plugin_init()
{
	register_plugin(PLUGIN_NAME, PLUGIN_VERSION, PLUGIN_AUTHOR)
	register_cvar(PLUGIN_CVAR, PLUGIN_VERSION, FCVAR_SERVER|FCVAR_SPONLY)
	
	register_dictionary("jb_ct_classes.txt")
	
	RegisterHam(Ham_Spawn, "player", "player_spawn", 1)
	register_logevent("round_start", 2, "0=World triggered", "1=Round_Start")
	
	gp_Informer = register_cvar("class_informer", "1")

	// register_clcmd("say /class", "class_menu") // For DEBUG
}

public client_disconnect(id)
{
	g_userclass[id] = 0;
	g_classselected[id] = false;
}

public client_putinserver(id)
{
	g_userclass[id] = 0;
	g_classselected[id] = false;
}

public round_start()
{
	gc_Informer = get_pcvar_num(gp_Informer)
}

public player_spawn(id)
{
	if(!is_user_connected(id))
		return PLUGIN_HANDLED;
		
	if(!is_user_ct(id))
		return PLUGIN_HANDLED;
		
	if(g_classselected[id])
	{
		g_nomsg[id] = true;
		class_set(id, g_userclass[id]);
	}
	
	class_menu(id);
	if(gc_Informer == 1)
	{
		set_task(1.0, "class_info", id, _, _, "b");
	}
	
	return PLUGIN_HANDLED;
}

public class_menu(id)
{
	if(!is_user_connected(id))
		return PLUGIN_HANDLED;
		
	if(!is_user_ct(id))
		return PLUGIN_HANDLED;
	
	static menu, menuname[128], option[128]
	
	formatex(menuname, charsmax(menuname), "%L", LANG_SERVER, "CLASS_MENU_TITLE");
	menu = menu_create(menuname, "class_menu_handler"); 
	 
	formatex(option, charsmax(option), "%L", LANG_SERVER, "CLASS_MENU_SPECIAL");
	menu_additem(menu, option, "1", 0);
	
	formatex(option, charsmax(option), "%L", LANG_SERVER, "CLASS_MENU_SPECNAZ");
	menu_additem(menu, option, "2", 0);
	
	formatex(option, charsmax(option), "%L", LANG_SERVER, "CLASS_MENU_SAS");
	menu_additem(menu, option, "3", 0);
	
	formatex(option, charsmax(option), "%L", LANG_SERVER, "CLASS_MENU_GSG");
	menu_additem(menu, option, "4", 0);
	
	formatex(option, charsmax(option), "%L", LANG_SERVER, "CLASS_MENU_SWAT");
	menu_additem(menu, option, "5", 0);
	
	formatex(option, charsmax(option), "%L", LANG_SERVER, "CLASS_MENU_POLICE");
	menu_additem(menu, option, "6", 0);
	
	formatex(option, charsmax(option), "%L", LANG_SERVER, "CLASS_MENU_COMANDER");
	menu_additem(menu, option, "7", 0);
	
	if(get_user_flags(id) & ADMIN_CLASS)
	{
		formatex(option, charsmax(option), "%L", LANG_SERVER, "CLASS_MENU_HEAVY");
		menu_additem(menu, option, "8");
	}
	else
	{
		formatex(option, charsmax(option), "%L", LANG_SERVER, "CLASS_MENU_HEAVY_DISABLED");
		menu_additem(menu, option, "8");
	}
	
	if(get_user_flags(id) & ADMIN_CLASS)
	{
		formatex(option, charsmax(option), "%L", LANG_SERVER, "CLASS_MENU_DEFENDER");
		menu_additem(menu, option, "9");
	}
	else
	{
		formatex(option, charsmax(option), "%L", LANG_SERVER, "CLASS_MENU_DEFENDER_DISABLED");
		menu_additem(menu, option, "9");
	}
	
	menu_display(id, menu); 
	return PLUGIN_HANDLED; 
}

public class_menu_handler(id, menu, item)
{
	if( item == MENU_EXIT )
	{
		menu_destroy( menu );
		return PLUGIN_HANDLED;
	}

	new data[ 6 ], iName[ 64 ], access, callback;
	menu_item_getinfo( menu, item, access, data, charsmax( data ), iName, charsmax( iName ), callback );

	new key = str_to_num( data );
	
	switch( key )
	{
		case 1:
		{
			g_classselected[id] = true;
			g_userclass[id] = 1;
			class_set(id, 1);
		}
		case 2:
		{
			g_classselected[id] = true;
			g_userclass[id] = 2;
			class_set(id, 2);
		}
		case 3:
		{
			g_classselected[id] = true;
			g_userclass[id] = 3;
			class_set(id, 3);
		}
		case 4:
		{
			g_classselected[id] = true;
			g_userclass[id] = 4;
			class_set(id, 4);	
		}
		case 5:
		{
			g_classselected[id] = true;
			g_userclass[id] = 5;
			class_set(id, 5);	
		}
		case 6:
		{
			g_classselected[id] = true;
			g_userclass[id] = 6;
			class_set(id, 6);	
		}
		case 7:
		{
			g_classselected[id] = true;
			g_userclass[id] = 7;
			class_set(id, 7);	
		}
		case 8:
		{
			if(get_user_flags(id) & ADMIN_CLASS)
			{
				g_classselected[id] = true;
				g_userclass[id] = 8;
				class_set(id, 8);	
			}
			else
			{
				class_menu(id);
				print_col(id, "%L", LANG_SERVER, "CLASS_MENU_NOT_ADMIN");
			}
		}
		case 9:
		{
			if(get_user_flags(id) & ADMIN_CLASS)
			{
				g_classselected[id] = true;
				g_userclass[id] = 9;
				class_set(id, 9);	
			}
			else
			{
				class_menu(id);
				print_col(id, "%L", LANG_SERVER, "CLASS_MENU_NOT_ADMIN");
			}
		}
	}
	return PLUGIN_HANDLED;
}

public class_set(id, class)
{
	if(!is_user_connected(id))
		return PLUGIN_HANDLED;
		
	if(!is_user_ct(id))
		return PLUGIN_HANDLED;
		
	switch(class)
	{
		case 1: 
		{ // SPECIAL
			strip_user_weapons(id);
			give_item(id, "weapon_knife");
			give_item(id, "weapon_m4a1");
			give_item(id, "weapon_usp");
			cs_set_user_bpammo(id, CSW_M4A1, 90);
			cs_set_user_bpammo(id, CSW_USP, 100);
			if(g_nomsg[id])
			{
				g_nomsg[id] = false;
			}
			else
			{
				print_col(id, "%L", LANG_SERVER, "CLASS_MENU_SPECIAL_SELECTED");
			}
		} // SPECIAL
		
		case 2:
		{ // SPECNAZ
			strip_user_weapons(id);
			give_item(id, "weapon_knife");
			give_item(id, "weapon_ak47");
			give_item(id, "weapon_glock18");
			cs_set_user_bpammo(id, CSW_AK47, 90);
			cs_set_user_bpammo(id, CSW_GLOCK18, 120);
			if(g_nomsg[id])
			{
				g_nomsg[id] = false;
			}
			else
			{
				print_col(id, "%L", LANG_SERVER, "CLASS_MENU_SPECNAZ_SELECTED");
			}
		} // SPECNAZ
		
		case 3:
		{ // SAS
			strip_user_weapons(id);
			give_item(id, "weapon_knife");
			give_item(id, "weapon_awp");
			give_item(id, "weapon_deagle");
			cs_set_user_bpammo(id, CSW_AWP, 30);
			cs_set_user_bpammo(id, CSW_DEAGLE, 35);
			if(g_nomsg[id])
			{
				g_nomsg[id] = false;
			}
			else
			{
				print_col(id, "%L", LANG_SERVER, "CLASS_MENU_SAS_SELECTED");
			}
		} // SAS
		
		case 4:
		{ // GSG
			strip_user_weapons(id);
			give_item(id, "weapon_knife");
			give_item(id, "weapon_ump45");
			give_item(id, "weapon_usp");
			cs_set_user_bpammo(id, CSW_UMP45, 100);
			cs_set_user_bpammo(id, CSW_USP, 100);
			if(g_nomsg[id])
			{
				g_nomsg[id] = false;
			}
			else
			{
				print_col(id, "%L", LANG_SERVER, "CLASS_MENU_GSG_SELECTED");
			}
		} // GSG
		
		case 5:
		{ // SWAT
			strip_user_weapons(id);
			give_item(id, "weapon_knife");
			give_item(id, "weapon_m3");
			give_item(id, "weapon_p228");
			cs_set_user_bpammo(id, CSW_M3, 32);
			cs_set_user_bpammo(id, CSW_P228, 52);
			if(g_nomsg[id])
			{
				g_nomsg[id] = false;
			}
			else
			{
				print_col(id, "%L", LANG_SERVER, "CLASS_MENU_SWAT_SELECTED");
			}
		} // SWAT
		
		case 6:
		{ // POLICE
			strip_user_weapons(id);
			give_item(id, "weapon_knife");
			give_item(id, "weapon_mac10");
			give_item(id, "weapon_deagle");
			cs_set_user_bpammo(id, CSW_MAC10, 100);
			cs_set_user_bpammo(id, CSW_DEAGLE , 35);
			if(g_nomsg[id])
			{
				g_nomsg[id] = false;
			}
			else
			{
				print_col(id, "%L", LANG_SERVER, "CLASS_MENU_POLICE_SELECTED");
			}
		} // POLICE
		
		case 7:
		{ // COMANDER
			strip_user_weapons(id);
			give_item(id, "weapon_knife");
			give_item(id, "weapon_aug");
			give_item(id, "weapon_p228");
			cs_set_user_bpammo(id, CSW_AUG, 90);
			cs_set_user_bpammo(id, CSW_P228, 52);
			if(g_nomsg[id])
			{
				g_nomsg[id] = false;
			}
			else
			{
				print_col(id, "%L", LANG_SERVER, "CLASS_MENU_COMANDER_SELECTED");
			}
		} // COMANDER
		
		case 8:
		{ // ADMIN HEAVY CLASS
			if(get_user_flags(id) & ADMIN_CLASS)
			{
				strip_user_weapons(id);
				give_item(id, "weapon_knife");
				client_cmd(id, "thompson")
				client_cmd(id, "infinity")
				give_item(id, "weapon_deagle");
				cs_set_user_bpammo(id, CSW_ELITE, 1000);
				cs_set_user_bpammo(id, CSW_DEAGLE, 1000);
				if(g_nomsg[id])
				{
					g_nomsg[id] = false;
				}
				else
				{
					print_col(id, "%L", LANG_SERVER, "CLASS_MENU_HEAVY_SELECTED");
				}
			}
			else
				return PLUGIN_HANDLED;
		} // ADMIN HEAVY CLASS
		
		case 9:
		{ // ADMIN DEFENDER CLASS
			if(get_user_flags(id) & ADMIN_CLASS)
			{
				strip_user_weapons(id);
				give_item(id, "weapon_knife");
				client_cmd(id, "infinity")
				give_item(id, "weapon_deagle");
				
				client_cmd(id, "kriss")
				cs_set_user_bpammo(id, CSW_ELITE, 1000);
				cs_set_user_bpammo(id, CSW_DEAGLE, 1000);
				if(g_nomsg[id])
				{
					g_nomsg[id] = false;
				}
				else
				{
					print_col(id, "%L", LANG_SERVER, "CLASS_MENU_DEFENDER_SELECTED");
				}
			}
			else
				return PLUGIN_HANDLED;
		} // ADMIN DEFENDER CLASS
	}
	
	return PLUGIN_HANDLED;
}

public class_info(id)
{
	if(!is_user_ct(id))
	{
		remove_task(id);
		return PLUGIN_HANDLED;
	}
	
	if(!is_user_alive(id))
	{
		remove_task(id);
		return PLUGIN_HANDLED;
	}
	new red = random_num(0, 255);
	new green = random_num(0, 255);
	new blue = random_num(0, 255);
	new health = get_user_health(id);
	new armor = get_user_armor(id);
	set_dhudmessage(red, green, blue, 0.0, 0.90, 0, 1.0, 1.0);
	switch(g_userclass[id])
	{
		case 0:
		{
			show_dhudmessage(id, "%L %L %L", LANG_SERVER, "CLASS_INFO_NOT_SELECTED", LANG_SERVER, "CLASS_INFO_HEALTH", health, LANG_SERVER, "CLASS_INFO_ARMOR", armor);
		}
		
		case 1:
		{
			show_dhudmessage(id, "%L %L %L", LANG_SERVER, "CLASS_INFO_SPECIAL", LANG_SERVER, "CLASS_INFO_HEALTH", health, LANG_SERVER, "CLASS_INFO_ARMOR", armor);
		}
		
		case 2:
		{
			show_dhudmessage(id, "%L %L %L", LANG_SERVER, "CLASS_INFO_SPECNAZ", LANG_SERVER, "CLASS_INFO_HEALTH", health, LANG_SERVER, "CLASS_INFO_ARMOR", armor);
		}
		
		case 3:
		{
			show_dhudmessage(id, "%L %L %L", LANG_SERVER, "CLASS_INFO_SAS", LANG_SERVER, "CLASS_INFO_HEALTH", health, LANG_SERVER, "CLASS_INFO_ARMOR", armor);
		}
		
		case 4:
		{
			show_dhudmessage(id, "%L %L %L", LANG_SERVER, "CLASS_INFO_GSG", LANG_SERVER, "CLASS_INFO_HEALTH", health, LANG_SERVER, "CLASS_INFO_ARMOR", armor);
		}
		
		case 5:
		{
			show_dhudmessage(id, "%L %L %L", LANG_SERVER, "CLASS_INFO_SWAT", LANG_SERVER, "CLASS_INFO_HEALTH", health, LANG_SERVER, "CLASS_INFO_ARMOR", armor);
		}
		
		case 6:
		{
			show_dhudmessage(id, "%L %L %L", LANG_SERVER, "CLASS_INFO_POLICE", LANG_SERVER, "CLASS_INFO_HEALTH", health, LANG_SERVER, "CLASS_INFO_ARMOR", armor);
		}
		
		case 7:
		{
			show_dhudmessage(id, "%L %L %L", LANG_SERVER, "CLASS_INFO_COMANDER", LANG_SERVER, "CLASS_INFO_HEALTH", health, LANG_SERVER, "CLASS_INFO_ARMOR", armor);
		}
		
		case 8:
		{
			show_dhudmessage(id, "%L %L %L", LANG_SERVER, "CLASS_INFO_HEAVY", LANG_SERVER, "CLASS_INFO_HEALTH", health, LANG_SERVER, "CLASS_INFO_ARMOR", armor);
		}
		
		case 9:
		{
			show_dhudmessage(id, "%L %L %L", LANG_SERVER, "CLASS_INFO_DEFENDER", LANG_SERVER, "CLASS_INFO_HEALTH", health, LANG_SERVER, "CLASS_INFO_ARMOR", armor);
		}
	}
	
	return PLUGIN_HANDLED;
}

/*============================================================
                     Stocks!
============================================================*/

stock bool:is_user_ct(id)
{
	if(cs_get_user_team(id) == CS_TEAM_CT)
		return true;
	else
		return false;
		
	return false;
}

stock print_col(const id, const input[], any:...)
{
    new count = 1, players[32]
    static msg[191]
    vformat(msg, 190, input, 3)
    
    replace_all(msg, 190, "!g", "^4") // Green Color
    replace_all(msg, 190, "!y", "^1") // Default Color
    replace_all(msg, 190, "!team", "^3") // Team Color
    
    if (id) players[0] = id; else get_players(players, count, "ch")
    {
        for (new i = 0; i < count; i++)
        {
            if (is_user_connected(players[i]))
            {
                message_begin(MSG_ONE_UNRELIABLE, get_user_msgid("SayText"), _, players[i])
                write_byte(players[i]);
                write_string(msg);
                message_end();
            }
        }
    }
}